### 在MetaFacture Redundancy两个冗余PLC设备上运行应用程序​

有关如何在两个PLC上将应用程序配置为冗余模式的步骤，请参见下面的步骤。

**提示！**

**用户管理**

如果在PLC上使用了用户管理，则必须配置相同的用户名和密码来访问两个PLC设备。否则，在线服务，例如write variable或online change不会传输到不活动的PLC。

要求：MetaFacture Redundancy的运行时系统组件都安装在两个PLC设备上。PLC处于运行状态。它们被命名为PLC1和PLC2.带有相应应用程序的工程在MetaFacture Development System中打开。

**配置工程**

1.在设备树中选择应用程序对象，然后插入***冗余配置***对象⇒将打开***冗余配置***对话框。

2.如果已经为顶级PLC配置了通讯设置，则MetaFacture将自动接受PLC1的通讯设置并在此对话框中显示它们。要将其设置为活动，请单击***设置活动路径PLC 1***按钮，打开通讯选项卡。

3.单击***冗余状态***选项卡中的***设置活动路径PLC 2***按钮。定义PLC2的通信路径。

4.在***冗余配置***编辑器中，选择***冗余设置***选项卡，然后选择***连接***选项卡。在***IP地址PLC 1***和***IP地址PLC2***中指定两个PLC设备的IP地址。如果可能，请选择一个单独的端口，尤其是仅用于PLC设备之间的连接。注意：对于OEM特定的冗余通讯，配置设置可能会有所不同。

5.切换到***常规***选项卡。定义设置，例如应控制处理（***冗余任务***），看门狗，要执行的服务以及所使用的现场总线应用程序任务的名称。  
EtherCAT设置：PLC1的源地址必须与EtherCAT主站中使用的地址一致。PLC2的源地址是用于PLC2的EtherCAT的适配器。

6.当两个PLC都在运行时，单击配置对话框右下方的***写入***按钮，以便在两个PLC设备的配置文件中指定设置。

7.可选的：对于我们的示例，通过冗余状态的编程查询在此处扩展应用程序。插入***程序***类型的***POU***。此步骤列表下方显示了一个示例。

8.如有必要，请停止两个PLC设备，因为只有在重新启动运行系统后，更改的设置才会激活。按照下述顺序重新启动。

> **检索冗余状态的程序示例**
> 
> PROGRAM PLC\_PRG  
> VAR  
>  state: RedundancyState;  
>  bResult: BOOL;  
> END\_VAR
> 
> bResult := RDCY.GetRedundancyState(ADR(state));

您始终可以通过监视***PLC\_PRG***中以及***冗余配置***编辑器的***冗余状态***选项卡中的变量state.eRedundancyState来遵循以下说明中描述的状态更改。

**将应用程序下载到PLC1**

1.启动PLC1（启动的两个PLC中的第一个进入独立模式。）打开***PLC\_PRG***的在线视图和***冗余配置***编辑器的***冗余状态***选项卡。  
⇒变量state.eRedundancyState包含值RS\_CYCLE\_STANDALONE。在图形表示中，该符号![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/672878dbacbd7.png)出现在PLC1处，该符号![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/672878e283aa2.png)出现在PLC2处。

2.在设备树中选择应用。单击***在线 ➔ 登陆***将应用程序下载到PLC1并通过单击***调试 ➔ 启动***启动应用程序。

3.如果未在应用程序属性中激活启动应用程序的自动创建，请单击***在线 ➔ 创建启动应用***。

**同步 PLC1和PLC2**

1.启动PLC2  
⇒PLC2从PLC1读取启动应用程序，并使数据与任务执行同步。PLC1的冗余状态切换为活动状态。变量state.eRedundancyState包含值RS\_CYCLE\_ACTIVE。在图形表示中，符号![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/67287919652a0.png)出现在PLC1上。同时PLC2切换到未激活状态![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/67287946a09f6.png)。两个PLC设备现在都在冗余模式下运行。

2.要检查两个PLC设备是否执行相同的应用程序，可以执行以下步骤：  
通过***在线 ➔ 退出***退出PLC1的登录状态。  
通过双击应用程序所在的设备树中的设备对象，打开PLC1的***通讯***选项卡。将连接设置更改为PLC2。  
单击***在线 ➔ 登陆***  
没有关于下载的消息。PLC2自动应用来自PLC1的启动应用程序。  
重要：将通讯设置更改回PLC1。  
检查PLC2的冗余状态：变量state.eRedundancyState收到值RS\_CYCLE\_ACTIVE。在图形表示中，符号![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/6728794c3fc43.png)出现在PLC2上。

3.要模拟PLC1的意外故障，请执行以下步骤：  
停止PLC1。结果，PLC1显示状态“未知” ，PLC2立即切换到状态“独立”![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/67287931b8741.png)。  
启动PLC1。PLC1状态“未激活”![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/67287938c86b5.png)以及PLC2切换为“激活”![](https://resource.helplook.net/docker_production/3648ne/article/rjz4Rj8A/67287920411c0.png)。

4.您可以通过***冗余状态***选项卡中的按钮执行以下操作：  
***转换***：激活PLC切换到状态“未激活”。  
***模拟***：活动的PLC切换到状态“模拟”（用于测试）。  
***激活***：仿真模式下的PLC切换到状态“激活”。  
***同步***：处于仿真模式或错误状态的PLC与另一个PLC同步，应用其数据，然后变为“被动”。